#include "GetPoint.js"

function GetEllipsePoint( pointpicker, factory )
{
	pointpicker.bindFuncPostUpdate( moi.ui.commandUI.OnPointUpdated );

	while ( 1 )
	{
		if ( !pointpicker.waitForEvent() )
			return false;
			
		if ( pointpicker.event == 'finished' )
		{
			break;
		}
		else if ( pointpicker.event == 'width' )
		{
			factory.setInput( 3, moi.ui.commandUI.width.value );
			factory.update();
			
			moi.ui.commandUI.g_HaveWidth = true;
		}
		else if ( pointpicker.event == 'height' )
		{
			factory.setInput( 4, moi.ui.commandUI.height.value );
			factory.update();
			
			moi.ui.commandUI.g_HaveHeight = true;
		}
	}
	
	return true;
}

function DoEllipse()
{
	var ui = moi.ui;

	var pointpicker = ui.createPointPicker();
	if ( !GetPoint( pointpicker ) )
		return;
		
	var centerpt = pointpicker.pt;

	var ellipsefactory = moi.command.createFactory( 'ellipse' );
	ellipsefactory.setInput( 0, pointpicker.pt );

	ui.commandUI.g_Factory = ellipsefactory;

	ui.beginUIUpdate();
	ui.hideUI( 'CenterPrompt' );
	ui.showUI( 'FirstAxisPrompt' );
	ui.showUI( 'WidthHeight' );
	ui.endUIUpdate();

	pointpicker.clearBindings();
	pointpicker.bindResultPt( ellipsefactory.getInput(1) );

	if ( !GetEllipsePoint( pointpicker, ellipsefactory ) )
		return;

	ui.beginUIUpdate();
	ui.hideUI( 'FirstAxisPrompt' );
	ui.showUI( 'SecondAxisPrompt' );
	ui.endUIUpdate();
	
	pointpicker.clearBindings();
	pointpicker.bindResultPt( ellipsefactory.getInput(2) );
	pointpicker.setBasePt( centerpt );
	
	if ( !GetEllipsePoint( pointpicker, ellipsefactory ) )
		return;


	ellipsefactory.commit();
}

DoEllipse();
